/*
 *  myFunctions.h
 *  3DFramework
 *
 *  This file contains signatures of all of the 3D routines required for 
 *  the 3D Pipeline Implementation Option.
 *
 *  Created by Joe Geigel on 9/25/07.
 *
 */

#ifdef WIN32
#include <windows.h>
#endif

#ifdef __APPLE__
#include <OPENGL/gl.h>
#else
#include <GL/gl.h>
#endif

/*
 * Defining polygons
 */
extern void myBegin(GLenum mode);
extern void myEnd();
extern void myVertex3f (float x, float y, float z);
extern void myColor3f(	float red, float green, float blue);


/*
 * clearing and drawing
 */
extern void myClearColor(	float red, float green, float blue, float alpha);
extern void myClear(GLbitfield mask);
extern void myFlush();

/*
 * Transformation routines
 */
#define X_AXIS 0
#define Y_AXIS 1
#define Z_AXIS 2
extern void myLoadIdentity( void);
extern void myTranslatef(float x, float y, float z);
extern void myRotatef(float angle, int axis);
extern void myScalef(float x, float y, float z);


/*
 * viewing
 */
extern void myFrustum(double left, double right, double bottom, double top, double near, double far);
extern void myOrtho(double left, double right, double bottom, double top, double near, double far);
extern void myLookAt( double eyeX, double eyeY, double eyeZ, double centerX, double centerY, double centerZ,double upX, double upY,double upZ );


/*
 * Projection / viewport
 */
extern void myViewport(int x, int y, int width, int height);







