/*
 *  3DPipeline
 *
 *  This program tests the 3D rendering pipeline.  
 *  
 *
 */

#ifdef WIN32
#include <windows.h>
#endif

#ifdef __APPLE__
#include <GLUT/glut.h>         /* glut.h includes gl.h and glu.h*/
#else
#include <GL/glut.h>
#endif
#include "myFunctions.h"
#include <stdlib.h>

int screenHeight = 300;
int screenWidth = 300;

int displayNumber = 0;   // 0 = ortho, 1 = transforms, 2 = perspective, 3 = camera, 4 = z-buffer, 5 = gouraud

/*
 * Callback for keystrokes
 */
void key (unsigned char key, int x, int y)
{
	if ((key == 'O') || (key == 'o')) displayNumber = 0; // ortho
	if ((key == 'T') || (key == 't')) displayNumber = 1; // transforms
	if ((key == 'P') || (key == 'p')) displayNumber = 2; // perspective
	if ((key == 'C') || (key == 'c')) displayNumber = 3; // camera
	if ((key == 'Z') || (key == 'z')) displayNumber = 4; // z-buffer
	if ((key == 'G') || (key == 'g')) displayNumber = 3; // gouraud	
	
	
	if ((key == 'Q') || (key == 'q')) exit(0); // quit

	
	glutPostRedisplay();
}


/* 
* Callback function for mouse interaction 
 */

void mouse( int button, int state, int x, int y ) {
	
	/* 
    * If state is not checked, we get two events for each mouse button
	 * usage, one for pressing it, one for releasing it 
	 */
	if ( state==GLUT_UP ) {
		displayNumber = (displayNumber + 1) % 5;
		glutPostRedisplay();
	}
	
}

/**
 * Ortho projection testing...the default
 */
 void drawOrtho()
 {
	// basic orthographic projection
	myOrtho (-10.0, 10.0, -10.0, 10.0, 1.0, 20.0);
	
	// camera looking down z-axis
	myLookAt (0.0, 0.0, 10.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
	
	// Draw a polygon
	myColor3f (1.0, 0.0, 0.0);
	myBegin (GL_POLYGON);
		myVertex3f (-3.535, -5.0, 3.535);
		myVertex3f (-3.535, 5.0, 3.535);
		myVertex3f (3.535, 5.0, -3.535);
		myVertex3f (3.535, -5.0, -3.535);
	myEnd();
	
 }

/**
* Gouraud shading test
 */
void drawGouraud()
{
	// basic orthographic projection
	myOrtho (-30.0, 30.0, -30.0, 30.0, 1.0, 20.0);
	
	// camera looking down z-axis
	myLookAt (0.0, 0.0, 10.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
	
	// Draw a polygon
	myBegin (GL_POLYGON);
	myColor3f (1.0, 0.0, 0.0);
	myVertex3f (0.0, 20.0, 0.0);
	myColor3f (0.0, 1.0, 0.0);
	myVertex3f (-15.0, 0.0, 0.0);
	myColor3f (0.0, 0.0, 1.0);
	myVertex3f (15.0, -5.0, 0.0);
	myEnd();
	
}


/**
 * Z buffer testing
 */
void drawZ ()
{
	// basic perspective projection
	myFrustum (-5.0, 5.0, -5.0, 5.0, 1.0, 20.0);
	
	// camera looking down z-axis
	myLookAt (0.0, 0.0, 10.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
	
	// big square in the back
	myColor3f (1.0, 0.0, 0.0);
	myBegin (GL_POLYGON);
	myVertex3f (-45.0, -45.0, -5.0);
	myVertex3f (-45.0, 45.0, -5.0);
	myVertex3f (45.0, 45.0, -5.0);
	myVertex3f (45.0, -45.0, -5.0);
	myEnd();
	
	// small triangle in front
	myColor3f (0.0, 0.0, 1.0);
	myBegin (GL_POLYGON);
	myVertex3f (-0.0, 15.0, 3.0);
	myVertex3f (-15.0, -10.0, 3.0);
	myVertex3f (15.0, -10.0, 3.0);
	myEnd();
	
	// triangle cutting in front
	myColor3f (1.0, 1.0, 0.0);
	myBegin (GL_POLYGON);
	myVertex3f (-5.0, 0.0, 8.0);
	myVertex3f (25.0, 20.0, -18.0);
	myVertex3f (25.0, -20.0, -18.0);
	myEnd();
	

}


/**
* Transformation testing...the default
 */
void drawTransforms()
{
	// basic perspective projection
	myFrustum (-5.0, 5.0, -5.0, 5.0, 1.0, 20.0);
	
	// camera looking down z-axis
	myLookAt (0.0, 0.0, 10.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
	
	// Draw a polygon -- translation
	myColor3f (1.0, 0.0, 0.0);
	myTranslatef (-15.0, 15.0, 2.0);
	myBegin (GL_POLYGON);
	myVertex3f (-1.0, -1.0, 0.0);
	myVertex3f (-1.0, 1.0, 0.0);
	myVertex3f (1.0, 1.0, 0.0);
	myVertex3f (1.0, -1.0, 0.0);
	myEnd();
	
	// Undo translation and try scaling
	myColor3f (0.0, 1.0, 0.0);
	myTranslatef (15.0, -15.0, -2.0);
	myTranslatef (30.0, -30.0, 0.0);
	myScalef (10.0, 15.0, 4.0);
	
	myBegin (GL_POLYGON);
	myVertex3f (-1.0, -1.0, 0.0);
	myVertex3f (-1.0, 1.0, 0.0);
	myVertex3f (1.0, 1.0, 0.0);
	myVertex3f (1.0, -1.0, 0.0);
	myEnd();
	
	// Undo translation and scaling - then rotate
	myColor3f (0.0, 0.0, 1.0);
	myScalef (0.10, 0.066667, 0.25);
	myTranslatef (-30.0, 30.0, 0.0);

	myTranslatef (15.0, 15.0, 0.0);
	myRotatef (45.0, X_AXIS);
	
	myBegin (GL_POLYGON);
	myVertex3f (-5.0, -5.0, 0.0);
	myVertex3f (-5.0, 5.0, 0.0);
	myVertex3f (5.0, 5.0, 0.0);
	myVertex3f (5.0, -5.0, 0.0);
	myEnd();
	
	/*******************/
	
	myColor3f (0.0, 1.0, 1.0);
	myRotatef (-45.0, X_AXIS);
	myTranslatef (-15.0, -15.0, 0.0);
	
	myTranslatef (-15.0, -15.0, 0.0);
	myRotatef (30.0, Y_AXIS);
	
	myBegin (GL_POLYGON);
	myVertex3f (-5.0, -5.0, 0.0);
	myVertex3f (-5.0, 5.0, 0.0);
	myVertex3f (5.0, 5.0, 0.0);
	myVertex3f (5.0, -5.0, 0.0);
	myEnd();
	
	/*******************/

	
	myColor3f (1.0, 0.0, 1.0);
	
	myRotatef (-30.0, Y_AXIS);
	myTranslatef (15.0, 15.0, 0.0);
	
	myRotatef (30.0, Z_AXIS);
	
	myBegin (GL_POLYGON);
	myVertex3f (-5.0, -5.0, 0.0);
	myVertex3f (-5.0, 5.0, 0.0);
	myVertex3f (5.0, 5.0, 0.0);
	myVertex3f (5.0, -5.0, 0.0);
	myEnd();
}



/**
* Perspective projection testing...
 */
void drawPerspective()
{
	// basic perspective projection
	myFrustum (-5.0, 5.0, -5.0, 5.0, 1.0, 20.0);
	
	// camera looking down z-axis
	myLookAt (0.0, 0.0, 5.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
	
	// Draw a polygon
	myColor3f (1.0, 0.0, 0.0);
	myBegin (GL_POLYGON);
	myVertex3f (-3.535, -5.0, 3.535);
	myVertex3f (-3.535, 5.0, 3.535);
	myVertex3f (3.535, 5.0, -3.535);
	myVertex3f (3.535, -5.0, -3.535);
	myEnd();
	
}


/* This will display the original world when the displaynumber is
* odd and an altered world when it is even.  "gluOrtho2D" is used
* to determine which portion of the world is displayed. "glViewport"
* is used to determine WHERE the selected portion will be displayed.
*/

void display( void ) {
	
	/* 
	* Set clear color to gray 
     */
    myClearColor ( 0.8, 0.8, 0.8, 0.0 );
	
    /* 
	* Clear screen window 
     */
    myClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
	
	/*
	 * set up a common (and simple) viewport
	 */
	 myViewport (0, 0, screenWidth, screenHeight);
		
	
	/* 
	 * plain old polygon test
	 */
	 myLoadIdentity();
	if ( displayNumber == 0 ) drawOrtho();
	if ( displayNumber == 1 ) drawTransforms();
	if ( displayNumber == 2 ) drawPerspective();
	if ( displayNumber == 3 ) drawZ();
	if ( displayNumber == 4 ) drawGouraud();
	
	/* 
     * Flush GL buffers to the display   
     */
    glFlush( );
	
}


/* 
* Main routine - GLUT setup and initialization 
 */

int main( int argc, char** argv ) {
	
	/* 
    * Initialize mode and open a window in upper 
	 * left corner of screen 
	 */
	glutInit( &argc, argv ); 
	glutInitDisplayMode( GLUT_DEPTH | GLUT_SINGLE | GLUT_RGB );
	glutInitWindowSize( screenWidth, screenHeight );
	glutInitWindowPosition( 0, 0 );
	glutCreateWindow( "Draw World" ); 
	
	glutMouseFunc( mouse );
	glutKeyboardFunc ( key );
	glutDisplayFunc( display );
	
	glutMainLoop();
	
	return 0;
	
}
